/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.json.text.rules.JSONNumberDetector;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class JSONNumberRule
extends ExtendedWordRule {
    private static final String REGEXP = "-?((([0-9]|[1-9][0-9]+)(\\.[0-9]+)?|\\.[0-9]+)(?:[eE][-+]?\\d+)?)";
    private static Pattern pattern;

    public JSONNumberRule(IToken token) {
        super((IWordDetector)new JSONNumberDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return JSONNumberRule.getPattern().matcher(word).matches();
    }

    private static synchronized Pattern getPattern() {
        if (pattern == null) {
            pattern = Pattern.compile(REGEXP);
        }
        return pattern;
    }
}

